<script>
  $(function() {

    // Menampilkan chart
    getChart();

    function getChart() {
      var ctx = document.getElementById("yearChart").getContext("2d");

      let url = "{{ route('api.chart.monthly') }}";

      $.ajax({
        url: url,
        type: "GET",
        success: function(response) {
          
          var myChart = new Chart(ctx, {
            type: "bar",
            data: {
              labels: [
                "Jan",
                "Feb",
                "Mar",
                "Apr",
                "Mei",
                "Jun",
                "Jul",
                "Agu",
                "Sep",
                "Okt",
                "Nov",
                "Des",
              ],
              datasets: [
                {
                  data: [
                          response.data.Jan,
                          response.data.Feb,
                          response.data.Mar,
                          response.data.Apr,
                          response.data.Mei,
                          response.data.Jun,
                          response.data.Jul,
                          response.data.Agu,
                          response.data.Sep,
                          response.data.Okt,
                          response.data.Nov,
                          response.data.Des
                        ],
                  backgroundColor: [
                    "rgba(255, 99, 132, 0.2)",
                    "rgba(54, 162, 235, 0.2)",
                    "rgba(255, 206, 86, 0.2)",
                    "rgba(75, 192, 192, 0.2)",
                    "rgba(153, 102, 255, 0.2)",
                    "rgba(255, 159, 64, 0.2)",
                    "rgba(255, 99, 132, 0.2)",
                    "rgba(54, 162, 235, 0.2)",
                    "rgba(255, 206, 86, 0.2)",
                    "rgba(75, 192, 192, 0.2)",
                    "rgba(153, 102, 255, 0.2)",
                    "rgba(255, 159, 64, 0.2)",
                  ],
                  borderColor: [
                    "rgba(255, 99, 132, 1)",
                    "rgba(54, 162, 235, 1)",
                    "rgba(255, 206, 86, 1)",
                    "rgba(75, 192, 192, 1)",
                    "rgba(153, 102, 255, 1)",
                    "rgba(255, 159, 64, 1)",
                    "rgba(255, 99, 132, 1)",
                    "rgba(54, 162, 235, 1)",
                    "rgba(255, 206, 86, 1)",
                    "rgba(75, 192, 192, 1)",
                    "rgba(153, 102, 255, 1)",
                    "rgba(255, 159, 64, 1)",
                  ],
                  borderWidth: 1,
                },
              ],
            },
            options: {
              legend: {
                display: false,
              },
              scales: {
                yAxes: [
                  {
                    ticks: {
                      beginAtZero: true,
                    },
                  },
                ],
              },
            },
          });
        }
      });
    }

    // Jika tombol refresh chart diklik
    $("#refresh-chart").click(function() {
      getChart()
    });
  });
</script>