<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-md-12">
        <?php echo $__env->make('components.alert-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">Data Klien</h6>
            </div>
            <div class="card-body">
                <a href="<?php echo e(route('klien.create')); ?>" class="btn btn-primary float-right mb-3">
                    Tambah Data
                </a>
                <div class="table-responsive">
                    <table class="table table-bordered" id="datatable" width="100%" cellspacing="0">
                        <thead class="text-center">
                            <tr>
                                <th>#</th>
                                <th>Nama Klien</th>
                                <th>Paket Internet</th>
                                <th>Nomor Handphone</th>
                                <th>Alamat IP</th>
                                <th>Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($loop->iteration); ?></td>
                                <td><?php echo e($client->name); ?></td>
                                <td>
                                    <span class="badge badge-pill badge-primary px-2 py-2 w-100">
                                        <?php echo e($client->internet_package->name); ?> -
                                        <?php echo e(indonesian_currency($client->internet_package->price)); ?>

                                    </span>
                                </td>
                                <td><?php echo e($client->phone_number); ?></td>
                                <td>
                                    <span class="badge badge-pill badge-secondary px-2 py-2 w-100">
                                        <?php echo e($client->ip_address); ?>

                                    </span>
                                </td>
                                <td class="text-center">
                                    <div class="btn-group" role="group" aria-label="Basic example">
                                        <a href="<?php echo e(route('klien.show', $client->id)); ?>" class="btn btn-primary btn-sm">
                                            <i class="fas fa-fw fa-search"></i>
                                        </a>
                                        <a href="<?php echo e(route('klien.edit', $client->id)); ?>" class="btn btn-success btn-sm">
                                            <i class="fas fa-fw fa-edit"></i>
                                        </a>
                                        <form action="<?php echo e(route('klien.destroy', $client->id)); ?>" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-danger btn-sm delete-button">
                                                <i class="fas fa-fw fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', [
'title' => 'Halaman Klien'
], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/willyap/Sites/wordpress/fakenet/resources/views/clients/index.blade.php ENDPATH**/ ?>